#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <unistd.h>

#define SHM_SIZE 1

int main(int argc, char *argv[])
{
    key_t key;
    int shmid, semid;
    int *data;
    int iznos;
    struct sembuf P, V;
    
    /* pravi kljuc */
    key = ftok("./shmem1.c", 'R');
	printf("Kljuc je %d\n", key);

    /* povezuje se (i ako je moguce kreira) segment */
    shmid = shmget(key, SHM_SIZE, 0644 | IPC_CREAT);
    printf("ID segmenta je %d\n", shmid);

    /* prikaci segment da bi dobio pokazivac na njega */
    data = (int *)shmat(shmid, NULL, 0);

    /* pravi kljuc za semafor */
    key = ftok("./shmem1.c", 'A');
	printf("Kljuc je %d\n", key);
    
    /* povezivanje na semafor */
    semid = semget(key, 1, 0);
    printf("ID skupa semafora je %d\n", semid);

    /* kreiranje operacija */
    P.sem_num = 0;
    P.sem_op = -1;
    P.sem_flg = 0;
    
    V.sem_num = 0;
    V.sem_op = 1;
    V.sem_flg = 0;

    /* kriticni region */
    semop(semid, &P, 1);
    iznos = (*data);
    printf("Procitao %d\n", iznos);
    
    sleep(10);
    
    printf("Smanjujem\n");
    iznos--;
    (*data) = iznos;
    printf("Deljena memorija %d\n", *data);
    semop(semid, &V, 1);
    /* kraj kriticnog regiona */

    /* odvaja se od segmenta */
    shmdt(data);

    return 0;
}


